@echo off
REM ##################  DominoRecovery.bat ########################
REM # You can use this batch file to recover your database files 
REM # from command line. Just customize the "User Defined Section"
REM # below with the values for your recovery action.
REM #############################################################


REM #########  Start: User Defined Section ######################

REM #################### PROGRAM_DIR ####################
REM ## The Domino or notes program directory, which contains notes.ini
SET PROGRAM_DIR=C:\Program Files\IBM\Lotus\Domino

REM #################### INPUT_FILE ####################
REM ## The path to a input file if you want to restore one
REM ## database only. If you want to restore all databases,
REM ## leave INPUT_FILE blank.
SET INPUT_FILE=

REM #################### RESTOREDB ####################
REM ## The path to a database file if you want to restore
REM ## one database only. If you want to restore all
REM ## databases, leave RESTOREDB blank.
SET RESTOREDB=

REM ############# RECDATE #################
REM ## The year, month and day you want to recover 
REM ## the database to in GMT+0. Set them according to the date format
REM ## MM/DD/YYYY
REM ## e.g. SET RECDATE=11/15/2006
REM ## If you want to restore all databases, leave RECDATE blank.
REM ## e.g. SET RECDATE=
SET RECDATE=


REM ############# RECTIME ####################
REM ## The time in hour and minute you want to recover the
REM ## database to in GMT+0. Set them according to the time format HH:mm:ss
REM ## e.g. SET RECTIME=13:00
REM ## If you want to restore all databases, leave RECTIME blank.
REM ## e.g. SET RECTIME=
SET RECTIME=

REM #################### APP_HOME ####################
REM ## You don't need to change this if you are running this batch file by 
REM ## double-clicking it.
REM ## 
SET APP_HOME=..

REM #########  End: User Defined Section ######################

IF NOT EXIST "%PROGRAM_DIR%\nnotes.dll" echo Invalid PROGRAM_DIR
IF NOT EXIST "%PROGRAM_DIR%\nnotes.dll" exit /B
IF NOT "%INPUT_FILE%"=="" (IF NOT EXIST "%INPUT_FILE%" echo %INPUT_FILE% does not exist.)
IF NOT "%INPUT_FILE%"=="" (IF NOT EXIST "%INPUT_FILE%" exit /B)
IF NOT "%RESTOREDB%"=="" (IF NOT EXIST "%RESTOREDB%" echo %RESTOREDB% does not exist.)
IF NOT "%RESTOREDB%"=="" (IF NOT EXIST "%RESTOREDB%" exit /B)
IF NOT "%INPUT_FILE%"=="" (IF "%RESTOREDB%"=="" echo Please enter both INPUT_FILE and RESTOREDB if you want to recover one database only. If you want to restore all databases, leave them empty.) ELSE (IF NOT "%RESTOREDB%" == "" echo Please enter both INPUT_FILE and RESTOREDB if you want to recover one database only. If you want to restore all databases, leave them empty.)
IF NOT "%INPUT_FILE%"=="" (IF "%RESTOREDB%"=="" exit /B) ELSE (IF NOT "%RESTOREDB%" == "" exit /B)
IF NOT "%INPUT_FILE%"=="" (IF "%INPUT_FILE%"=="%RESTOREDB%" echo INPUT_FILE and RESTOREDB must be different.)
IF NOT "%INPUT_FILE%"=="" (IF "%INPUT_FILE%"=="%RESTOREDB%" exit /B)
IF "%INPUT_FILE%"=="" (IF NOT "%RECDATE%%RECTIME%"=="" echo Leave RECDATE and RECTIME blank if you want to restore all databases.)
IF "%INPUT_FILE%"=="" (IF NOT "%RECDATE%%RECTIME%"=="" exit /B)
IF NOT "%INPUT_FILE%%RESTOREDB%"=="" (IF "%RECDATE%"=="" echo Please enter RECDATE and RECTIME if you want to recover one database only.)
IF NOT "%INPUT_FILE%%RESTOREDB%"=="" (IF "%RECDATE%"=="" exit /B)
IF NOT "%INPUT_FILE%%RESTOREDB%"=="" (IF "%RECTIME%"=="" echo Please enter RECDATE and RECTIME if you want to recover one database only.)
IF NOT "%INPUT_FILE%%RESTOREDB%"=="" (IF "%RECTIME%"=="" exit /B)

REM ############# EXECUTE ####################
REM ## RESTORE and OPTION must not be empty
REM ## 
SET RESTORE=RESTORE
SET OPTION=NEW_DBIID
SET PATH=%JAVA_HOME%\bin;%PATH%;%PROGRAM_DIR%

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
  SET "EXEC_PATH=LotusBMWinX86"
) ELSE (
  SET "EXEC_PATH=LotusBMWinX64"
)
%EXEC_PATH% "OPT=%RESTORE%" "FLAG=%OPTION%" "IN=%INPUT_FILE%" "OUT=%RESTOREDB%" "DATETIME=%RECDATE% %RECTIME%"

CD %APP_HOME%
pause