@ECHO OFF
SETLOCAL
SETLOCAL ENABLEDELAYEDEXPANSION
REM CLS
REM ################################################################
REM # You can use this batch to export the group and user          #
REM # directory objects from Active Directory                      #
REM #                                                              #
REM # Last Updated: 2012-12-11                                     #
REM ################################################################

REM //Variables
REM //User argument
SET "VAR_EXPT_HOSTNAME="
SET "VAR_EXPT_DOMAIN="
SET "VAR_EXPT_FILE_OUT=fExport.ldf"
SET "VAR_EXPT_VERBOSE= "
SET "VAR_EXPT_PINFO=2"
SET "VAR_EXPT_FLAG=0"

REM //Parse input paraments
FOR %%i IN (%*) DO CALL :export_parseArgument %%i

IF %VAR_EXPT_PINFO% LSS 0 (
  CALL :export_printHelp
  GOTO export_exit
)

IF /I "%VAR_EXPT_HOSTNAME%"=="" (
  REM //Get computer hostname
  FOR /F "usebackq tokens=* delims=" %%i IN (`dsquery server -o rdn 2^>^&1`) DO SET "VAR_EXPT_HOSTNAME=%%i"
)
IF /I "%VAR_EXPT_DOMAIN%"=="" (
  REM //Get computer base domain
  FOR /F "usebackq tokens=* delims=" %%i IN (`dsquery * domainroot -scope base 2^>^&1`) DO SET "VAR_EXPT_DOMAIN=%%i"
) ELSE (
  SET "VAR_EXPT_DOMAIN="%VAR_EXPT_DOMAIN%""
)

IF %VAR_EXPT_PINFO% GEQ 2 CALL :export_printConfig

REM //Delete existing file
CALL :export_remove_file "%VAR_EXPT_FILE_OUT%"

REM //Export AD to file
ECHO.^>^>^> Exporting directory objects...
ldifde -m -f "%VAR_EXPT_FILE_OUT%" -s %VAR_EXPT_HOSTNAME% -d %VAR_EXPT_DOMAIN% -p subtree -r "(|(objectClass=group)(&(objectCategory=person)(objectClass=User)))" -o "userAccountControl" %VAR_EXPT_VERBOSE%

REM //Exit point
:export_exit
REM //Delete variables
SET "VAR_EXPT_HOSTNAME="
SET "VAR_EXPT_DOMAIN="
SET "VAR_EXPT_FILE_OUT="
SET "VAR_EXPT_VERBOSE= "
SET "VAR_EXPT_PINFO="
SET "VAR_EXPT_FLAG="
ENDLOCAL
GOTO :eof


REM //Sub-routine to print help message
REM //In:
REM //Out:
:export_printHelp
ECHO.Input arguments:
ECHO.     fout:[output file]
ECHO.     hostname:[hostname]
ECHO.     domain:[domain]
ECHO.     verbose:[0/1/2]
ECHO.     help
ECHO.
ECHO. (Use double quotation marks the argument
ECHO.  if it contains any space char eg."argu ment")
ECHO.
ECHO.  fout - exported .ldf destination file
ECHO.  hostname - computer hostname (auto detect if missing)
ECHO.  domain - active directory domain (auto detect if missing)
ECHO.  verbose - level of information show
ECHO.
GOTO :eof

REM //Sub-routine to print current config
REM //In:
REM //Out:
:export_printConfig
ECHO.Current config:
ECHO.     output file: %VAR_EXPT_FILE_OUT%
ECHO.     hostname:    %VAR_EXPT_HOSTNAME%
ECHO.     domain:      %VAR_EXPT_DOMAIN%
ECHO.
GOTO :eof

REM //Sub-routine to parse input paraments
REM //In: [argument]
REM //Out:
:export_parseArgument
IF %VAR_EXPT_PINFO% LSS 0 GOTO export_parseArgument_exit
SET "VAR_EXPT_FLAG=0"
FOR /F "tokens=1,* delims=:" %%i IN ("%~1") DO (
  IF /I "%%i"=="HOSTNAME" SET "VAR_EXPT_HOSTNAME=%%j" & SET "VAR_EXPT_FLAG=1"
  IF /I "%%i"=="DOMAIN" (
    IF /I "%VAR_EXPT_DOMAIN%"=="" (
	  SET "VAR_EXPT_DOMAIN=DC=%%j" & SET "VAR_EXPT_FLAG=1"
	) ELSE (
	  SET "VAR_EXPT_DOMAIN=%VAR_EXPT_DOMAIN%,DC=%%j" & SET "VAR_EXPT_FLAG=1"
	)
  )
  IF /I "%%i"=="FOUT" SET "VAR_EXPT_FILE_OUT=%%j" & SET "VAR_EXPT_FLAG=1"
  IF /I "%%i"=="VERBOSE" (
    IF /I "%%j"=="1" SET "VAR_EXPT_VERBOSE=-j ." & SET "VAR_EXPT_FLAG=1"
    IF /I "%%j"=="2" SET "VAR_EXPT_VERBOSE=-v -j ." & SET "VAR_EXPT_FLAG=1"
  )
  IF /I "%%i"=="INFO" SET "VAR_EXPT_PINFO=%%j" & SET "VAR_EXPT_FLAG=1"

  REM //Default
  IF /I "%%j"=="" SET "VAR_EXPT_PINFO=-1"
  IF !VAR_EXPT_FLAG! LEQ 0 SET "VAR_EXPT_PINFO=-1"
)
:export_parseArgument_exit
GOTO :eof

REM //Sub-routine to remove a file
REM //In: [file]
REM //Out:
:export_remove_file
IF EXIST "%~1" (
  REM ECHO.remove file "%~1"
  DEL "%~1"
) ELSE (
  REM ECHO.remove file "%~1" not found
)
GOTO :eof